<?php
// Database configuration
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "TEST";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$check_drivers = "SELECT COUNT(*) as count FROM s_salrep";
$result = $conn->query($check_drivers);
$row = $result->fetch_assoc();
if ($row['count'] == 0) {    
}

// Handle form submission
$selected_driver = isset($_POST['driver']) ? intval($_POST['driver']) : 0;
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : date('Y-m-d', strtotime('-7 days'));
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : date('Y-m-d');

// Get drivers for dropdown
$drivers_query = "SELECT REPCODE, Name, RGROUP FROM drivers ORDER BY Name";
$drivers_result = $conn->query($drivers_query);

// Get location data for selected driver and date range
$location_data = [];
$driver_info = [];
if ($selected_driver > 0) {
    // Get driver info
    $driver_query = "SELECT REPCODE, Name FROM drivers WHERE REPCODE = ?";
    $stmt = $conn->prepare($driver_query);
    $stmt->bind_param("i", $selected_driver);
    $stmt->execute();
    $driver_result = $stmt->get_result();
    $driver_info = $driver_result->fetch_assoc();
    
    // Get location data
    $location_query = "SELECT lan, lot, ref_no, remark 
                      FROM vendor_visit 
                      WHERE ref_no1 = ? AND DATE(timestamp) BETWEEN ? AND ? 
                      ORDER BY timestamp";
    $stmt = $conn->prepare($location_query);
    $stmt->bind_param("iss", $selected_driver, $start_date, $end_date);
    $stmt->execute();
    $location_result = $stmt->get_result();
    
    while($row = $location_result->fetch_assoc()) {
        $location_data[] = $row;
    }
}

// Close connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Call Sheet - Google Maps</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flot/0.8.3/jquery.flot.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flot/0.8.3/jquery.flot.time.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flot/0.8.3/jquery.flot.resize.min.js"></script>
    
    <!-- Google Maps API -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyC_nk97W3UxiLraamtck74XfOK9pPsNlH4&libraries=geometry,places"></script>
    
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }
        
        header {
            background: linear-gradient(135deg, #2c3e50, #4a6491);
            color: white;
            padding: 20px 0;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        header h1 {
            text-align: center;
            font-size: 2.2rem;
            margin-bottom: 10px;
        }
        
        .driver-info {
            background: #3498db;
            padding: 15px;
            border-radius: 6px;
            margin: 10px 20px;
            text-align: center;
        }
        
        .controls {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: #2c3e50;
        }
        
        select, input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        
        button {
            background: #3498db;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: background 0.3s;
            width: 100%;
        }
        
        button:hover {
            background: #2980b9;
        }
        
        .map-container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
            height: 600px;
        }
        
        .map-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 8px;
        }
        
        #google-map {
            width: 100%;
            height: 100%;
            border: 1px solid #eee;
            border-radius: 4px;
        }
        
        .charts-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .chart-card {
            flex: 1;
            min-width: 300px;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .chart {
            width: 100%;
            height: 300px;
        }
        
        .data-table {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        
        th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #2c3e50;
        }
        
        tr:hover {
            background-color: #f8f9fa;
        }
        
        .no-data {
            text-align: center;
            padding: 40px;
            color: #7f8c8d;
            font-style: italic;
        }
        
        .stats {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .stat-card {
            flex: 1;
            min-width: 150px;
            background: white;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .stat-value {
            font-size: 1.8rem;
            font-weight: 700;
            color: #3498db;
        }
        
        .stat-label {
            font-size: 0.9rem;
            color: #7f8c8d;
            margin-top: 5px;
        }
        
        .map-controls {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        
        .map-btn {
            background: #2c3e50;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }
        
        .map-btn:hover {
            background: #1a252f;
        }
        
        /* Responsive styles */
        @media (min-width: 768px) {
            .form-row {
                display: flex;
                gap: 20px;
            }
            
            .form-group {
                flex: 1;
            }
            
            button {
                width: auto;
            }
        }
        
        @media (max-width: 767px) {
            header h1 {
                font-size: 1.8rem;
            }
            
            .charts-container {
                flex-direction: column;
            }
            
            .map-container {
                height: 400px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>Driver Travel History Tracking</h1>
            <?php if (!empty($driver_info)): ?>
                <div class="driver-info">
                    <h2><?php echo htmlspecialchars($driver_info['name']); ?></h2>
                    <p>Vehicle: <?php echo htmlspecialchars($driver_info['vehicle_number']); ?></p>
                </div>
            <?php endif; ?>
        </header>
        
        <div class="controls">
            <form method="POST" action="">
                <div class="form-row">
                    <div class="form-group">
                        <label for="driver">Select Sales Person:</label>
                        <select id="driver" name="driver" required>
                            <option value="">-- Select a Driver --</option>
                            <?php
                            if ($drivers_result->num_rows > 0) {
                                while($driver = $drivers_result->fetch_assoc()) {
                                    $selected = ($driver['id'] == $selected_driver) ? 'selected' : '';
                                    echo "<option value='{$driver['id']}' $selected>{$driver['name']} - {$driver['vehicle_number']}</option>";
                                }
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="start_date">Start Date:</label>
                        <input type="date" id="start_date" name="start_date" value="<?php echo $start_date; ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="end_date">End Date:</label>
                        <input type="date" id="end_date" name="end_date" value="<?php echo $end_date; ?>" required>
                    </div>
                    
                    <div class="form-group" style="display: flex; align-items: flex-end;">
                        <button type="submit">Show Travel History</button>
                    </div>
                </div>
            </form>
        </div>
        
        <?php if ($selected_driver > 0): ?>
            <?php if (!empty($location_data)): ?>
                <div class="stats">
                    <div class="stat-card">
                        <div class="stat-value"><?php echo count($location_data); ?></div>
                        <div class="stat-label">Location Points</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-value">
                            <?php 
                            $start = new DateTime($location_data[0]['timestamp']);
                            $end = new DateTime($location_data[count($location_data)-1]['timestamp']);
                            $interval = $start->diff($end);
                            echo $interval->format('%a days, %h hours');
                            ?>
                        </div>
                        <div class="stat-label">Tracking Period</div>
                    </div>
                    <!-- <div class="stat-card">
                        <div class="stat-value">
                            <?php 
                            $totalSpeed = 0;
                            $count = 0;
                            foreach($location_data as $location) {
                                if ($location['speed'] > 0) {
                                    $totalSpeed += $location['speed'];
                                    $count++;
                                }
                            }
                            echo $count > 0 ? round($totalSpeed / $count, 1) . ' km/h' : 'N/A';
                            ?>
                        </div>
                        <div class="stat-label">Avg Speed</div>
                    </div> -->
                    <div class="stat-card">
                        <div class="stat-value">
                            <?php 
                            $totalDistance = 0;
                            for ($i = 1; $i < count($location_data); $i++) {
                                $prev = $location_data[$i-1];
                                $curr = $location_data[$i];
                                
                                // Calculate distance using Haversine formula
                                $lat1 = deg2rad($prev['latitude']);
                                $lon1 = deg2rad($prev['longitude']);
                                $lat2 = deg2rad($curr['latitude']);
                                $lon2 = deg2rad($curr['longitude']);
                                
                                $delta_lat = $lat2 - $lat1;
                                $delta_lon = $lon2 - $lon1;
                                
                                $a = sin($delta_lat/2) * sin($delta_lat/2) + 
                                     cos($lat1) * cos($lat2) * 
                                     sin($delta_lon/2) * sin($delta_lon/2);
                                $c = 2 * atan2(sqrt($a), sqrt(1-$a));
                                $distance = 6371 * $c; // Earth radius in km
                                
                                $totalDistance += $distance;
                            }
                            echo round($totalDistance, 2) . ' km';
                            ?>
                        </div>
                        <div class="stat-label">Total Distance</div>
                    </div>
                </div>
                
                <div class="map-container">
                    <div class="map-title">Driver Travel Route - Google Maps</div>
                    <div class="map-controls">
                        <button class="map-btn" id="toggle-markers">Toggle Markers</button>
                        <button class="map-btn" id="toggle-route">Toggle Route</button>
                        <button class="map-btn" id="fit-bounds">Fit to Route</button>
                        <button class="map-btn" id="reset-map">Reset Map</button>
                    </div>
                    <div id="google-map"></div>
                </div>
                
                <div class="charts-container">
                    <div class="chart-card">
                        <div class="map-title">Speed Over Time</div>
                        <div id="speed-chart" class="chart"></div>
                    </div>
                    
                    <div class="chart-card">
                        <div class="map-title">Distance Traveled</div>
                        <div id="distance-chart" class="chart"></div>
                    </div>
                </div>
                
                <div class="data-table">
                    <h2>Location History</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Timestamp</th>
                                <th>Latitude</th>
                                <th>Longitude</th>
                                <th>Speed (km/h)</th>
                                <th>Address</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($location_data as $index => $location): ?>
                                <tr>
                                    <td><?php echo $location['timestamp']; ?></td>
                                    <td><?php echo $location['latitude']; ?></td>
                                    <td><?php echo $location['longitude']; ?></td>
                                    <td><?php echo $location['speed']; ?></td>
                                    <td id="address-<?php echo $index; ?>">
                                        <em>Loading...</em>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="no-data">No location data found for the selected driver and date range.</div>
            <?php endif; ?>
        <?php else: ?>
            <div class="no-data">Please select a driver to view their travel history.</div>
        <?php endif; ?>
    </div>

    <script>
        $(document).ready(function() {
            <?php if (!empty($location_data)): ?>
                // Prepare data for visualization
                var locationData = <?php echo json_encode($location_data); ?>;
                var map;
                var markers = [];
                var routePolyline;
                var geocoder;
                var showMarkers = true;
                var showRoute = true;
                
                // Initialize Google Map
                function initGoogleMap() {
                    geocoder = new google.maps.Geocoder();
                    
                    var mapOptions = {
                        zoom: 12,
                        center: new google.maps.LatLng(
                            parseFloat(locationData[0].latitude),
                            parseFloat(locationData[0].longitude)
                        ),
                        mapTypeId: google.maps.MapTypeId.ROADMAP,
                        styles: [
                            {
                                "featureType": "administrative",
                                "elementType": "labels.text.fill",
                                "stylers": [{"color": "#444444"}]
                            },
                            {
                                "featureType": "landscape",
                                "elementType": "all",
                                "stylers": [{"color": "#f2f2f2"}]
                            },
                            {
                                "featureType": "poi",
                                "elementType": "all",
                                "stylers": [{"visibility": "off"}]
                            },
                            {
                                "featureType": "road",
                                "elementType": "all",
                                "stylers": [{"saturation": -100}, {"lightness": 45}]
                            },
                            {
                                "featureType": "road.highway",
                                "elementType": "all",
                                "stylers": [{"visibility": "simplified"}]
                            },
                            {
                                "featureType": "road.arterial",
                                "elementType": "labels.icon",
                                "stylers": [{"visibility": "off"}]
                            },
                            {
                                "featureType": "transit",
                                "elementType": "all",
                                "stylers": [{"visibility": "off"}]
                            },
                            {
                                "featureType": "water",
                                "elementType": "all",
                                "stylers": [{"color": "#3498db"}, {"visibility": "on"}]
                            }
                        ]
                    };
                    
                    map = new google.maps.Map(document.getElementById('google-map'), mapOptions);
                    
                    // Create markers and route
                    createRouteAndMarkers();
                    
                    // Geocode addresses for table
                    geocodeAddresses();
                }
                
                function createRouteAndMarkers() {
                    var bounds = new google.maps.LatLngBounds();
                    var path = [];
                    
                    // Clear existing markers and route
                    markers.forEach(function(marker) {
                        marker.setMap(null);
                    });
                    markers = [];
                    
                    if (routePolyline) {
                        routePolyline.setMap(null);
                    }
                    
                    // Create markers and path
                    locationData.forEach(function(location, index) {
                        var position = new google.maps.LatLng(
                            parseFloat(location.latitude), 
                            parseFloat(location.longitude)
                        );
                        
                        bounds.extend(position);
                        path.push(position);
                        
                        if (showMarkers) {
                            var marker = new google.maps.Marker({
                                position: position,
                                map: map,
                                title: 'Point ' + (index + 1) + ' - ' + location.timestamp,
                                label: {
                                    text: (index + 1).toString(),
                                    color: 'white',
                                    fontWeight: 'bold'
                                },
                                icon: {
                                    url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(
                                        '<svg width="20" height="20" xmlns="http://www.w3.org/2000/svg">' +
                                        '<circle cx="10" cy="10" r="8" fill="#e74c3c" stroke="#c0392b" stroke-width="2"/>' +
                                        '<text x="10" y="14" text-anchor="middle" fill="white" font-size="10" font-weight="bold">' + (index + 1) + '</text>' +
                                        '</svg>'
                                    )
                                }
                            });
                            
                            // Add info window
                            var infowindow = new google.maps.InfoWindow({
                                content: '<div class="map-info-window">' +
                                         '<h3>Point ' + (index + 1) + '</h3>' +
                                         '<p><strong>Time:</strong> ' + location.timestamp + '</p>' +
                                         '<p><strong>Speed:</strong> ' + location.speed + ' km/h</p>' +
                                         '<p><strong>Lat:</strong> ' + location.latitude + '</p>' +
                                         '<p><strong>Lng:</strong> ' + location.longitude + '</p>' +
                                         '</div>'
                            });
                            
                            marker.addListener('click', function() {
                                infowindow.open(map, marker);
                            });
                            
                            markers.push(marker);
                        }
                    });
                    
                    // Create route polyline
                    if (showRoute) {
                        routePolyline = new google.maps.Polyline({
                            path: path,
                            geodesic: true,
                            strokeColor: '#3498db',
                            strokeOpacity: 0.8,
                            strokeWeight: 4
                        });
                        
                        routePolyline.setMap(map);
                    }
                    
                    // Fit map to bounds
                    map.fitBounds(bounds);
                }
                
                function geocodeAddresses() {
                    locationData.forEach(function(location, index) {
                        var latlng = {
                            lat: parseFloat(location.latitude),
                            lng: parseFloat(location.longitude)
                        };
                        
                        geocoder.geocode({'location': latlng}, function(results, status) {
                            if (status === 'OK') {
                                if (results[0]) {
                                    $('#address-' + index).text(results[0].formatted_address);
                                } else {
                                    $('#address-' + index).text('Address not found');
                                }
                            } else {
                                $('#address-' + index).text('Geocoding failed: ' + status);
                            }
                        });
                    });
                }
                
                // Initialize Speed Chart
                function initSpeedChart() {
                    var speedData = locationData.map(function(loc, index) {
                        return [index, parseFloat(loc.speed)];
                    });
                    
                    $.plot("#speed-chart", [{
                        data: speedData,
                        color: "#e74c3c",
                        lines: { show: true, fill: false, lineWidth: 2 },
                        points: { show: true, radius: 3 }
                    }], {
                        xaxis: {
                            tickDecimals: 0,
                            label: "Data Point"
                        },
                        yaxis: {
                            min: 0,
                            label: "Speed (km/h)"
                        },
                        grid: {
                            backgroundColor: "white",
                            borderWidth: 1,
                            borderColor: "#ddd",
                            hoverable: true
                        }
                    });
                }
                
                // Initialize Distance Chart
                function initDistanceChart() {
                    var distances = [0];
                    var totalDistance = 0;
                    
                    for (var i = 1; i < locationData.length; i++) {
                        var prev = locationData[i-1];
                        var curr = locationData[i];
                        
                        // Calculate distance using Google Maps Geometry
                        var prevLatLng = new google.maps.LatLng(
                            parseFloat(prev.latitude),
                            parseFloat(prev.longitude)
                        );
                        var currLatLng = new google.maps.LatLng(
                            parseFloat(curr.latitude),
                            parseFloat(curr.longitude)
                        );
                        
                        var distance = google.maps.geometry.spherical.computeDistanceBetween(
                            prevLatLng, currLatLng
                        ) / 1000; // Convert to kilometers
                        
                        totalDistance += distance;
                        distances.push(totalDistance);
                    }
                    
                    var distanceData = distances.map(function(dist, index) {
                        return [index, dist];
                    });
                    
                    $.plot("#distance-chart", [{
                        data: distanceData,
                        color: "#2ecc71",
                        lines: { show: true, fill: false, lineWidth: 2 },
                        points: { show: true, radius: 3 }
                    }], {
                        xaxis: {
                            tickDecimals: 0,
                            label: "Data Point"
                        },
                        yaxis: {
                            min: 0,
                            label: "Distance (km)"
                        },
                        grid: {
                            backgroundColor: "white",
                            borderWidth: 1,
                            borderColor: "#ddd",
                            hoverable: true
                        }
                    });
                }
                
                // Map control functions
                $('#toggle-markers').click(function() {
                    showMarkers = !showMarkers;
                    createRouteAndMarkers();
                    $(this).text(showMarkers ? 'Hide Markers' : 'Show Markers');
                });
                
                $('#toggle-route').click(function() {
                    showRoute = !showRoute;
                    createRouteAndMarkers();
                    $(this).text(showRoute ? 'Hide Route' : 'Show Route');
                });
                
                $('#fit-bounds').click(function() {
                    var bounds = new google.maps.LatLngBounds();
                    locationData.forEach(function(location) {
                        bounds.extend(new google.maps.LatLng(
                            parseFloat(location.latitude),
                            parseFloat(location.longitude)
                        ));
                    });
                    map.fitBounds(bounds);
                });
                
                $('#reset-map').click(function() {
                    map.setZoom(12);
                    map.setCenter(new google.maps.LatLng(
                        parseFloat(locationData[0].latitude),
                        parseFloat(locationData[0].longitude)
                    ));
                });
                
                // Initialize all visualizations
                initGoogleMap();
                initSpeedChart();
                // Distance chart is initialized after Google Maps loads
                google.maps.event.addDomListener(window, 'load', function() {
                    setTimeout(initDistanceChart, 1000);
                });
                
            <?php endif; ?>
        });
    </script>
</body>
</html>